<?php
/**
 * Plugin Name: かんたんリンク補助プラグイン
 * Description: かんたんリンク（msmaflink）に target="_blank" と rel="noopener" を自動追加します。
 * Version: 1.4.0
 * Author: Kasuga
 * License: GPLv2 or later
 * Requires at least: 6.3
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * @package KantanLinkHelper
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * 必要なページだけフッターにスクリプトを出力
 */
function kantanlink_helper_output_script() {

	/* 管理画面・REST・Ajaxを除外 */
	if ( is_admin() || wp_doing_ajax() || wp_is_json_request() ) {
		return;
	}

	/* 投稿・固定ページのみ */
	if ( ! is_singular() ) {
		return;
	}

	global $post;
	if ( ! $post instanceof WP_Post ) {
		return;
	}

	/* かんたんリンクが本文に存在しない場合は出力しない */
	if ( strpos( $post->post_content, 'msmaflink-' ) === false ) {
		return;
	}
	?>
	<script>
	(function () {
		function setBlank() {
			document.querySelectorAll('[id^="msmaflink-"] a').forEach(function (a) {
				a.target = '_blank';
				a.rel = 'noopener';
			});
		}

		window.addEventListener('load', setBlank);

		new MutationObserver(setBlank).observe(document.body, {
		childList: true,
		subtree: true
		});
	})();
	</script>
	<?php
}
add_action( 'wp_footer', 'kantanlink_helper_output_script', 100 );